/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.model.DragonHeadModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class SkullTileEntityRenderer
extends TileEntityRenderer<SkullTileEntity> {
    private static final Map<SkullBlock.ISkullType, GenericHeadModel> field_199358_e = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        GenericHeadModel genericHeadModel = new GenericHeadModel(0, 0, 64, 32);
        HumanoidHeadModel \u26032 = new HumanoidHeadModel();
        DragonHeadModel \u26033 = new DragonHeadModel(0.0f);
        hashMap.put(SkullBlock.Types.SKELETON, genericHeadModel);
        hashMap.put(SkullBlock.Types.WITHER_SKELETON, genericHeadModel);
        hashMap.put(SkullBlock.Types.PLAYER, \u26032);
        hashMap.put(SkullBlock.Types.ZOMBIE, \u26032);
        hashMap.put(SkullBlock.Types.CREEPER, genericHeadModel);
        hashMap.put(SkullBlock.Types.DRAGON, \u26033);
    });
    private static final Map<SkullBlock.ISkullType, ResourceLocation> field_199357_d = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        hashMap.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
        hashMap.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
        hashMap.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
        hashMap.put(SkullBlock.Types.DRAGON, new ResourceLocation("textures/entity/enderdragon/dragon.png"));
        hashMap.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.func_177335_a());
    });

    public SkullTileEntityRenderer(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    @Override
    public void func_225616_a_(SkullTileEntity skullTileEntity, float f, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, int n2) {
        float f2 = skullTileEntity.func_184295_a(f);
        BlockState \u26032 = skullTileEntity.func_195044_w();
        boolean \u26033 = \u26032.func_177230_c() instanceof WallSkullBlock;
        Direction \u26034 = \u26033 ? \u26032.func_177229_b(WallSkullBlock.field_196302_a) : null;
        \u2603 = 22.5f * (float)(\u26033 ? (2 + \u26034.func_176736_b()) * 4 : \u26032.func_177229_b(SkullBlock.field_196294_a));
        SkullTileEntityRenderer.func_228879_a_(\u26034, \u2603, ((AbstractSkullBlock)\u26032.func_177230_c()).func_196292_N_(), skullTileEntity.func_152108_a(), f2, matrixStack, iRenderTypeBuffer, n);
    }

    public static void func_228879_a_(@Nullable Direction direction, float f, SkullBlock.ISkullType iSkullType, @Nullable GameProfile gameProfile, float f2, MatrixStack matrixStack2, IRenderTypeBuffer iRenderTypeBuffer, int n) {
        MatrixStack matrixStack2;
        GenericHeadModel genericHeadModel = field_199358_e.get(iSkullType);
        matrixStack2.func_227860_a_();
        if (direction == null) {
            matrixStack2.func_227861_a_(0.5, 0.0, 0.5);
        } else {
            float f3 = 0.25f;
            matrixStack2.func_227861_a_(0.5f - (float)direction.func_82601_c() * 0.25f, 0.25, 0.5f - (float)direction.func_82599_e() * 0.25f);
        }
        matrixStack2.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder \u26032 = iRenderTypeBuffer.getBuffer(SkullTileEntityRenderer.func_228878_a_(iSkullType, gameProfile));
        genericHeadModel.func_225603_a_(f2, f, 0.0f);
        genericHeadModel.func_225598_a_(matrixStack2, \u26032, n, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack2.func_227865_b_();
    }

    private static RenderType func_228878_a_(SkullBlock.ISkullType iSkullType, @Nullable GameProfile gameProfile) {
        ResourceLocation resourceLocation = field_199357_d.get(iSkullType);
        if (iSkullType != SkullBlock.Types.PLAYER || gameProfile == null) {
            return RenderType.func_239267_e_(resourceLocation);
        }
        Minecraft \u26032 = Minecraft.func_71410_x();
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> \u26033 = \u26032.func_152342_ad().func_152788_a(gameProfile);
        if (\u26033.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return RenderType.func_228644_e_(\u26032.func_152342_ad().func_152792_a(\u26033.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return RenderType.func_228640_c_(DefaultPlayerSkin.func_177334_a(PlayerEntity.func_146094_a(gameProfile)));
    }
}

